package ru.yandex.mail.cerberus.exception;

import ru.yandex.mail.cerberus.ErrorCode;
import ru.yandex.mail.cerberus.LocationKey;

import java.util.Collection;

public class LocationNotFoundException extends EntityNotFoundException {
    public LocationNotFoundException(String message) {
        super(message);
    }

    public LocationNotFoundException(LocationKey key) {
        super("Location", key);
    }

    public LocationNotFoundException(Collection<LocationKey> keys) {
        super("Locations", keys);
    }

    @Override
    public ErrorCode getErrorCode() {
        return ErrorCode.LOCATION_NOT_FOUND;
    }
}
