package ru.yandex.mail.cerberus.exception;

import ru.yandex.mail.cerberus.ErrorCode;
import ru.yandex.mail.cerberus.ResourceKey;

import java.util.Collection;

public class ResourceAlreadyExistsException extends EntityAlreadyExistsException {
    public ResourceAlreadyExistsException(String message) {
        super(message);
    }

    public ResourceAlreadyExistsException(ResourceKey key) {
        super("Resource", key);
    }

    public ResourceAlreadyExistsException(Collection<ResourceKey> keys) {
        super("Resources", keys);
    }

    @Override
    public ErrorCode getErrorCode() {
        return ErrorCode.RESOURCE_ALREADY_EXISTS;
    }
}
