package ru.yandex.mail.cerberus.exception;

import ru.yandex.mail.cerberus.ErrorCode;
import ru.yandex.mail.cerberus.ResourceKey;

import java.util.Collection;

public class ResourceNotFoundException extends EntityNotFoundException {
    public ResourceNotFoundException(String message) {
        super(message);
    }

    public ResourceNotFoundException(ResourceKey key) {
        super("Resource", key);
    }

    public ResourceNotFoundException(Collection<ResourceKey> keys) {
        super("Resources", keys);
    }

    @Override
    public ErrorCode getErrorCode() {
        return ErrorCode.RESOURCE_NOT_FOUND;
    }
}
