package ru.yandex.mail.cerberus.exception;

import ru.yandex.mail.cerberus.ErrorCode;
import ru.yandex.mail.cerberus.ResourceTypeName;

import java.util.Collection;

public class ResourceTypeAlreadyExistsException extends EntityAlreadyExistsException {
    public ResourceTypeAlreadyExistsException(String message) {
        super(message);
    }

    public ResourceTypeAlreadyExistsException(ResourceTypeName name) {
        super("Resource type", name);
    }

    public ResourceTypeAlreadyExistsException(Collection<ResourceTypeName> names) {
        super("Resource types", names);
    }

    @Override
    public ErrorCode getErrorCode() {
        return ErrorCode.RESOURCE_TYPE_ALREADY_EXISTS;
    }
}
