package ru.yandex.mail.cerberus.exception;

import ru.yandex.mail.cerberus.ErrorCode;
import ru.yandex.mail.cerberus.ResourceTypeName;

import java.util.Collection;

public class ResourceTypeNotFoundException extends EntityNotFoundException {
    public ResourceTypeNotFoundException(String message) {
        super(message);
    }

    public ResourceTypeNotFoundException(Collection<ResourceTypeName> names) {
        super("Resource types", names);
    }

    public ResourceTypeNotFoundException(ResourceTypeName name) {
        super("Resource type", name);
    }

    @Override
    public ErrorCode getErrorCode() {
        return ErrorCode.RESOURCE_TYPE_NOT_FOUND;
    }
}
