package ru.yandex.mail.cerberus.exception;

import ru.yandex.mail.cerberus.ErrorCode;
import ru.yandex.mail.cerberus.RoleId;

import java.util.Collection;

public class RoleAlreadyExistsException extends EntityAlreadyExistsException {
    public RoleAlreadyExistsException(String message) {
        super(message);
    }

    public RoleAlreadyExistsException(RoleId id) {
        super("Role", id);
    }

    public RoleAlreadyExistsException(Collection<RoleId> ids) {
        super("Roles", ids);
    }

    @Override
    public ErrorCode getErrorCode() {
        return ErrorCode.ROLE_ALREADY_EXISTS;
    }
}
