package ru.yandex.mail.cerberus.exception;

import ru.yandex.mail.cerberus.ErrorCode;
import ru.yandex.mail.cerberus.RoleId;
import ru.yandex.mail.cerberus.RoleName;

import java.util.Collection;

public class RoleNotFoundException extends EntityNotFoundException {
    public RoleNotFoundException(String message) {
        super(message);
    }

    public RoleNotFoundException(RoleName name) {
        super("Role", name);
    }

    public RoleNotFoundException(RoleId id) {
        super("Role", id);
    }

    public RoleNotFoundException(Collection<RoleId> ids) {
        super("Roles", ids);
    }

    @Override
    public ErrorCode getErrorCode() {
        return ErrorCode.ROLE_NOT_FOUND;
    }
}
