package ru.yandex.mail.cerberus.exception;

import ru.yandex.mail.cerberus.ErrorCode;

import java.util.Collection;
import java.util.Set;

public class UnsupportedActionsException extends InputException {
    public UnsupportedActionsException(Collection<String> unsupportedActions, Set<String> allowedActions) {
        super("Unsupported actions found: [" + String.join(", ", unsupportedActions) + "].\n"
            + "Allowed: [" + String.join(", ", allowedActions) + "]");
    }

    @Override
    public ErrorCode getErrorCode() {
        return ErrorCode.UNSUPPORTED_ACTIONS;
    }
}
