package ru.yandex.mail.cerberus.exception;

import ru.yandex.mail.cerberus.ErrorCode;
import ru.yandex.mail.cerberus.Uid;

import java.util.Collection;

public class UserAlreadyExistsException extends EntityAlreadyExistsException {
    public UserAlreadyExistsException(String message) {
        super(message);
    }

    public UserAlreadyExistsException(Uid uid) {
        super("User", uid);
    }

    public UserAlreadyExistsException(Collection<Uid> uids) {
        super("Users", uids);
    }

    @Override
    public ErrorCode getErrorCode() {
        return ErrorCode.USER_ALREADY_EXISTS;
    }
}
