package ru.yandex.mail.cerberus.worker.api;

import io.micronaut.context.annotation.AliasFor;
import io.micronaut.context.annotation.DefaultScope;

import javax.inject.Named;
import javax.inject.Singleton;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Named
@DefaultScope(Singleton.class)
@Target({ElementType.TYPE, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface Processor {
    @AliasFor(annotation = Named.class, member = "value")
    String value() default "";
}
