package ru.yandex.mail.cerberus.worker.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.micronaut.core.annotation.Introspected;
import lombok.AllArgsConstructor;
import lombok.Value;
import ru.yandex.mail.cerberus.IdempotencyKey;
import ru.yandex.mail.cerberus.dao.task.TaskRepository;
import ru.yandex.mail.cerberus.dao.task.TaskStatus;

import java.time.OffsetDateTime;

@Value
@Introspected
@AllArgsConstructor(onConstructor_= @JsonCreator)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class SubmitResult {
    IdempotencyKey idempotencyKey;
    TaskStatus status;
    OffsetDateTime scheduled;
    OffsetDateTime created;
    String requestId;

    public SubmitResult(TaskRepository.GenericTaskInfo taskInfo) {
        this(taskInfo.getIdempotencyKey(), taskInfo.getStatus(), taskInfo.getSchedule(), taskInfo.getCreated(), taskInfo.getRequestId());
    }
}
