package ru.yandex.mail.cerberus.worker.api;

import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import lombok.AllArgsConstructor;
import lombok.Data;
import ru.yandex.mail.cerberus.TaskType;

import javax.inject.Inject;
import java.time.Duration;
import java.util.Optional;

@Data
@AllArgsConstructor
@EachProperty(TaskConfiguration.PROPERTY_NAME)
public class TaskConfiguration {
    public static final Duration MAX_TIMEOUT = Duration.ofHours(3);
    public static final String PROPERTY_NAME = "cerberus.worker.tasks";

    private final TaskType taskType;
    private Duration timeout;
    private Optional<Duration> repetitionRate = Optional.empty();

    @Inject
    public TaskConfiguration(@Parameter String name) {
        this.taskType = new TaskType(name);
    }

    public void setRepetitionRate(Duration repetitionRate) {
        this.repetitionRate = Optional.ofNullable(repetitionRate);
    }

    public void setTimeout(Duration timeout) {
        if (timeout.compareTo(MAX_TIMEOUT) > 0) {
            throw new IllegalArgumentException("Task timeout can't be greater that " + MAX_TIMEOUT +
                ", but task " + taskType + " timeout = " + timeout);
        }
        this.timeout = timeout;
    }

    public boolean isRepeatable() {
        return repetitionRate.isPresent();
    }
}
