package ru.yandex.mail.cerberus.worker.api;

import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public interface TaskExecutor {
    <Context> CompletableFuture<SubmitResult> submit(Task<Context> task, Optional<Long> initiatorUid, Duration delay);

    default <Context> CompletableFuture<SubmitResult> submit(Task<Context> task, Optional<Long> initiatorUid) {
        return submit(task, initiatorUid, Duration.ZERO);
    }
}
