package ru.yandex.mail.cerberus.worker.exception;

import ru.yandex.mail.cerberus.IdempotencyKey;
import ru.yandex.mail.cerberus.TaskType;
import ru.yandex.mail.cerberus.worker.api.Task;

public class TaskNotFoundException extends RuntimeException {
    public TaskNotFoundException(IdempotencyKey key, TaskType type) {
        super("Task " + type + " is not found for idempotency key " + key);
    }

    public <Parameter> TaskNotFoundException(Task<Parameter> task) {
        this(task.getIdempotencyKey(), task.getType());
    }
}
