package ru.yandex.mail.cerberus.worker.executer;

import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.context.event.StartupEvent;
import lombok.AllArgsConstructor;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import ru.yandex.mail.cerberus.IdempotencyKey;
import ru.yandex.mail.cerberus.worker.TaskRegistry;
import ru.yandex.mail.cerberus.worker.api.Task;
import ru.yandex.mail.cerberus.worker.api.TaskConfiguration;
import ru.yandex.mail.cerberus.worker.api.TaskExecutor;

import javax.inject.Inject;
import javax.inject.Singleton;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import static com.ea.async.Async.await;
import static ru.yandex.mail.micronaut.common.Async.done;

@Slf4j
@Singleton
@AllArgsConstructor(onConstructor_= @Inject)
public class CronTaskSpawner implements ApplicationEventListener<StartupEvent> {
    private final TaskRegistry taskRegistry;
    private final TaskExecutor taskExecutor;

    private CompletableFuture<Void> scheduleCronTask(TaskConfiguration configuration) {
        val type = configuration.getTaskType();
        log.info("Trying to schedule cron task {}", type);
        val task = new Task<>(type, IdempotencyKey.random(), Optional.empty());
        val result = await(taskExecutor.submit(task, Optional.empty(), Duration.ZERO));
        log.info("Cron task {} with idempotency key {} scheduled to run at {}",
            type, result.getIdempotencyKey(), result.getScheduled());
        return done();
    }

    @Override
    @SneakyThrows
    public void onApplicationEvent(StartupEvent event) {
        val scheduleFutures = taskRegistry.configurations()
            .filter(TaskConfiguration::isRepeatable)
            .map(this::scheduleCronTask)
            .toArray(CompletableFuture.class);
        CompletableFuture.allOf(scheduleFutures).get();
    }
}
