JAVA_PROGRAM(cerberus_worker)

JDK_VERSION(11)

OWNER(
    g:calendar-back
)

GENERATE_SCRIPT(
    TEMPLATE ${ARCADIA_ROOT}/mail/cerberus/classpath.tmpl
    OUT ${BINDIR}/cerberus_worker.classpath
)

NO_LINT()
CHECK_JAVA_DEPS(yes)

JAVAC_FLAGS(
    -parameters
    -Xlint:unchecked
)

JAVA_SRCS(SRCDIR src/main/java **/*)
JAVA_SRCS(RESOURCES SRCDIR src/main/resources **/*)

INCLUDE(../../../micronaut/dependency_versions.inc)
INCLUDE(../../../micronaut/micronaut_http_server.inc)
INCLUDE(../../../micronaut/micronaut_http_client.inc)
INCLUDE(../../micronaut_jdbc.inc)

PEERDIR(
    mail/micronaut/micrometer
    mail/cerberus/worker/api
    mail/micronaut/http_logger
    mail/micronaut/http_logger/http_logger_log4j2

    contrib/java/org/apache/logging/log4j/log4j-1.2-api
    contrib/java/org/apache/logging/log4j/log4j-slf4j-impl
    contrib/java/com/fasterxml/jackson/dataformat/jackson-dataformat-yaml
    contrib/java/io/micronaut/micronaut-management
    contrib/java/com/lmax/disruptor
    contrib/java/io/netty/netty-transport-native-epoll-linux-x86_64
)

EXCLUDE(
    contrib/java/log4j/log4j
)

ANNOTATION_PROCESSOR(
    lombok.launch.AnnotationProcessorHider$AnnotationProcessor
    io.micronaut.annotation.processing.TypeElementVisitorProcessor
    io.micronaut.annotation.processing.PackageConfigurationInjectProcessor
    io.micronaut.annotation.processing.BeanDefinitionInjectProcessor
)

END()

RECURSE_FOR_TESTS(
    ut
)
