package ru.yandex.mail.cerberus.worker.tasks;

import reactor.core.publisher.Mono;
import ru.yandex.mail.cerberus.dao.general.GeneralRepository;
import ru.yandex.mail.cerberus.dao.tx.TxManager;
import ru.yandex.mail.micronaut.common.qualifier.Master;
import ru.yandex.mail.cerberus.worker.api.Processor;
import ru.yandex.mail.cerberus.worker.api.TaskExecutionContext;
import ru.yandex.mail.cerberus.worker.api.TaskProcessor;

import javax.inject.Inject;
import java.util.Optional;

@Processor(PgPartmanMaintenanceTaskProcessor.TYPE)
public class PgPartmanMaintenanceTaskProcessor implements TaskProcessor<Void> {
    static final String TYPE = "partman-maintenance";

    private final TxManager txManager;
    private final GeneralRepository generalRepository;

    @Inject
    public PgPartmanMaintenanceTaskProcessor(@Master TxManager txManager, GeneralRepository generalRepository) {
        this.txManager = txManager;
        this.generalRepository = generalRepository;
    }

    @Override
    public Class<Void> contextType() {
        return void.class;
    }

    @Override
    public Mono<Void> process(Optional<Void> aVoid, TaskExecutionContext executionContext) {
        return Mono.fromFuture(txManager.runAsync(generalRepository::runPgPartmanMaintenance));
    }
}
