package ru.yandex.mail.cerberus.worker.yt_tasks.staff_sync.sync;

import lombok.Value;
import one.util.streamex.StreamEx;
import ru.yandex.mail.cerberus.yt.staff.StaffEntity;

import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

@Value
class Batch<T, Ctx> {
    List<StaffEntity<T>> values;
    Ctx context;

    public Optional<OffsetDateTime> findMaxModificationTime(Function<T, OffsetDateTime> modifiedAtExtractor) {
        return StreamEx.of(values)
            .filter(StaffEntity::isValid)
            .map(StaffEntity::getEntity)
            .map(modifiedAtExtractor)
            .max(OffsetDateTime.timeLineOrder());
    }
}
