package ru.yandex.mail.cerberus.worker.yt_tasks.staff_sync.sync;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.Value;

import java.util.Set;

import static java.util.Collections.singleton;

@NoArgsConstructor(access = AccessLevel.PRIVATE)
abstract class SyncDecision {
    @Value
    @AllArgsConstructor
    @EqualsAndHashCode(callSuper = false)
    public static class DontSync extends SyncDecision {
        Set<String> reasons;

        public DontSync(String reason) {
            this(singleton(reason));
        }
    }

    @Value
    @AllArgsConstructor
    @EqualsAndHashCode(callSuper = false)
    public static class UpdateOnly extends SyncDecision {
        Set<String> reasons;

        public UpdateOnly(String reason) {
            this(singleton(reason));
        }
    }

    public static SyncDecision SYNC = new SyncDecision() {
    };
}
