package ru.yandex.mail.cerberus.worker.yt_tasks.staff_sync.sync;

import org.slf4j.Logger;
import reactor.core.publisher.Flux;

import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

interface SyncProvider<ID, Ctx, Dto, StaffDto> {
    int getMaxChunkSize();

    String getSyncEntityName();

    Logger getLog();

    SyncOrder getOrder();

    OffsetDateTime getModifiedAt(StaffDto dto);

    ID getIdForDto(Dto dto);

    ID getIdForStaffDto(StaffDto dto);

    SyncDecision isReadyToSync(StaffDto dto, Ctx context);

    Dto update(Dto dto, StaffDto staffDto, Ctx context);

    Flux<Batch<StaffDto, Ctx>> batches(Optional<OffsetDateTime> syncPoint);

    CompletableFuture<List<Dto>> findExisting(List<StaffDto> dtos, Ctx context);

    CompletableFuture<List<Dto>> commitNew(List<StaffDto> dtos, Ctx context);

    CompletableFuture<Void> commitChanged(List<Dto> dtos, Ctx context);
}
