package ru.yandex.mail.cerberus.worker.yt_tasks.staff_sync.sync;

import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;

import javax.inject.Named;
import javax.inject.Singleton;

@Factory
public class SynchronizerFactory {
    @Bean
    @Singleton
    @Named("group")
    public Synchronizer groupSynchronizer(GroupSyncProvider provider) {
        return new DefaultSynchronizer<>(provider);
    }

    @Bean
    @Singleton
    @Named("office")
    public Synchronizer officeSynchronizer(OfficeSyncProvider provider) {
        return new DefaultSynchronizer<>(provider);
    }

    @Bean
    @Singleton
    @Named("room")
    public Synchronizer roomSynchronizer(RoomSyncProvider provider) {
        return new DefaultSynchronizer<>(provider);
    }

    @Bean
    @Singleton
    @Named("user")
    public Synchronizer userSynchronizer(UserSyncProvider provider) {
        return new DefaultSynchronizer<>(provider);
    }
}
