package ru.yandex.mail.cerberus.yt.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.micronaut.core.annotation.Introspected;
import lombok.AllArgsConstructor;
import lombok.Value;
import ru.yandex.mail.cerberus.yt.staff.dto.StaffLocalizedString;

import java.time.ZoneId;

@Value
@Introspected
@AllArgsConstructor(onConstructor_= @JsonCreator)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class YtOfficeInfo {
    StaffLocalizedString name;
    String code;
    StaffLocalizedString cityName;
    ZoneId timezone;
    boolean deleted;
}
