package ru.yandex.mail.cerberus.yt.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.micronaut.core.annotation.Introspected;
import lombok.AllArgsConstructor;
import lombok.Value;

import javax.validation.constraints.PositiveOrZero;
import java.util.OptionalInt;

@Value
@Introspected
@AllArgsConstructor(onConstructor_= @JsonCreator)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class YtRoomInfo {
    @Value
    @Introspected
    @AllArgsConstructor(onConstructor_= @JsonCreator)
    @JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
    public static class Equipment {
        boolean corkBoard;
        boolean desk;
        String gameConsole;
        boolean guestWifi;
        boolean markerBoard;
        @PositiveOrZero int projector;
        @PositiveOrZero int screen;
        @PositiveOrZero int seats;
        String videoConferencing;
        boolean voiceConferencing;
    }

    @PositiveOrZero long floorId;
    OptionalInt floorNumber;
    String displayName;
    String ruName;
    String enName;
    String alternativeName;
    String additional;
    int capacity;
    Equipment equipment;
    String phone;
    boolean bookable;
}
