package ru.yandex.mail.cerberus.yt.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.micronaut.core.annotation.Introspected;
import lombok.AllArgsConstructor;
import lombok.Value;
import ru.yandex.mail.cerberus.GroupId;
import ru.yandex.mail.cerberus.LocationId;
import ru.yandex.mail.cerberus.yt.staff.dto.StaffUser;

import javax.validation.constraints.PositiveOrZero;
import java.time.ZoneId;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;

@Value
@Introspected
@AllArgsConstructor(onConstructor_= @JsonCreator)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class YtUserInfo {
    public enum Trait {
        ROBOT,
        HOMEWORKER,
        DELETED,
        DISMISSED
    }

    @PositiveOrZero long id;
    StaffUser.Affiliation affiliation;
    String workEmail;
    ZoneId timezone;
    LocationId officeId;
    OptionalInt floorNumber;
    String uiLanguage;
    String firstNameRu;
    String lastNameRu;
    String firstNameEn;
    String lastNameEn;
    Optional<String> middleName;
    String positionRu;
    String positionEn;
    StaffUser.Gender gender;
    Optional<@PositiveOrZero Long> workPhone;
    List<StaffUser.Phone> phones;
    EnumSet<Trait> traits;
    List<StaffUser.Car> cars;
    Optional<GroupId> departmentId;
    Optional<String> workMode;

    @JsonIgnore
    public boolean is(Trait trait) {
        return traits.contains(trait);
    }

    @JsonIgnore
    public boolean isAllOf(Collection<Trait> traits) {
        return this.traits.containsAll(traits);
    }

    @JsonIgnore
    public boolean isAllOf(Trait... traits) {
        return isAllOf(List.of(traits));
    }

    @JsonIgnore
    public boolean isRobot() {
        return is(Trait.ROBOT);
    }

    @JsonIgnore
    public boolean isHomeworker() {
        return is(Trait.HOMEWORKER);
    }

    @JsonIgnore
    public boolean isDeleted() {
        return is(Trait.DELETED);
    }

    @JsonIgnore
    public boolean isDismissed() {
        return is(Trait.DISMISSED);
    }
}
