package ru.yandex.mail.cerberus.yt.mapper;

import java.util.Collections;
import java.util.Comparator;
import java.util.Set;

import javax.inject.Singleton;

import lombok.val;
import one.util.streamex.StreamEx;

import ru.yandex.mail.cerberus.client.dto.Group;
import ru.yandex.mail.cerberus.yt.data.YtDepartmentInfo;
import ru.yandex.mail.cerberus.yt.staff.StaffConstants;
import ru.yandex.mail.cerberus.yt.staff.dto.StaffDepartmentGroup;
import ru.yandex.mail.cerberus.yt.staff.dto.StaffDepartmentHead;

import static java.util.Collections.emptySet;
import static java.util.function.Predicate.not;

@Singleton
public class YtDepartmentMapper {
    private static Set<StaffDepartmentHead> findStepHeads(StaffDepartmentGroup group) {
        return StreamEx.of(group.getAncestors())
            .map(StaffDepartmentGroup.Ancestor::getDepartment)
            .reverseSorted(Comparator.comparingInt(StaffDepartmentGroup.Ancestor.Info::getLevel))
            .findFirst(not(department -> department.getHeads().isEmpty()))
            .map(StaffDepartmentGroup.Ancestor.Info::getHeads)
            .orElse(emptySet());
    }

    public Group<YtDepartmentInfo> mapToGroup(StaffDepartmentGroup departmentGroup) {
        val department = departmentGroup.getDepartment();
        if (StaffDepartmentGroup.Types.DEPARTMENT.equalsIgnoreCase(departmentGroup.getType())) {
            val departmentHeads = department.getHeads();
            val chiefsUid = StreamEx.of(departmentHeads.isEmpty() ? findStepHeads(departmentGroup) : departmentHeads)
                    .flatMap(head -> head.getUidSafe().stream())
                    .toImmutableSet();
            val fullName = department.getName().getFull();
            val info = new YtDepartmentInfo(chiefsUid, department.getUrl(), fullName.getRu(), fullName.getEn());
            val name = fullName.getEn();
            val active = !department.isDeleted();
            return new Group<>(departmentGroup.getId(), StaffConstants.YT_DEPARTMENT_GROUP_TYPE, name, active, info);
        } else {
            val info = new YtDepartmentInfo(Collections.emptySet(), departmentGroup.getUrl(), departmentGroup.getName(), departmentGroup.getName());
            return new Group<>(departmentGroup.getId(), StaffConstants.YT_DEPARTMENT_GROUP_TYPE,
                    departmentGroup.getName(), !departmentGroup.isDeleted(), info);
        }
    }
}
