package ru.yandex.mail.cerberus.yt.mapper;

import lombok.val;
import ru.yandex.mail.cerberus.client.dto.Location;
import ru.yandex.mail.cerberus.yt.data.YtOfficeInfo;
import ru.yandex.mail.cerberus.yt.staff.StaffConstants;
import ru.yandex.mail.cerberus.yt.staff.dto.StaffOffice;

import javax.inject.Singleton;
import java.util.Optional;

@Singleton
public class YtOfficeMapper {
    public Location<YtOfficeInfo> mapToLocation(StaffOffice office) {
        val info = new YtOfficeInfo(office.getName(), office.getCode(), office.getCity().getName(), office.getTimezone(),
            office.isDeleted());
        return new Location<>(office.getId(), StaffConstants.YT_OFFICE_TYPE, office.getName().getEn(), Optional.of(info));
    }
}
