package ru.yandex.mail.cerberus.yt.mapper;

import lombok.val;
import ru.yandex.mail.cerberus.LocationKey;
import ru.yandex.mail.cerberus.client.dto.Resource;
import ru.yandex.mail.cerberus.yt.data.YtRoomInfo;
import ru.yandex.mail.cerberus.yt.staff.StaffConstants;
import ru.yandex.mail.cerberus.yt.staff.dto.StaffRoom;

import javax.inject.Singleton;
import java.util.Optional;

@Singleton
public class YtRoomMapper {
    public Resource<YtRoomInfo> mapToResource(StaffRoom room) {
        val name = room.getName();
        val floor = room.getFloor();
        val location = new LocationKey(floor.getOffice().getId(), StaffConstants.YT_OFFICE_TYPE);
        val info = new YtRoomInfo(floor.getId(), floor.getNumber(), name.getDisplay(), name.getRu(), name.getEn(),
            name.getAlternative(), room.getAdditional(), room.getCapacitySafe(), room.getEquipment(), room.getPhone(), room.isBookable());
        return new Resource<>(room.getId(), StaffConstants.YT_ROOM_RESOURCE_TYPE_NAME, name.getExchange(), Optional.of(location),
            !room.isDeleted() && room.isBookable(), Optional.of(info));
    }
}
