package ru.yandex.mail.cerberus.yt.mapper;

import lombok.val;
import one.util.streamex.EntryStream;
import ru.yandex.mail.cerberus.UserType;
import ru.yandex.mail.cerberus.client.dto.User;
import ru.yandex.mail.cerberus.yt.data.YtUserInfo;
import ru.yandex.mail.cerberus.yt.data.YtUserInfo.Trait;
import ru.yandex.mail.cerberus.yt.staff.dto.StaffUser;

import javax.inject.Singleton;

import static java.util.function.Predicate.isEqual;
import static java.util.function.Predicate.not;
import static one.util.streamex.MoreCollectors.toEnumSet;

@Singleton
public class YtUserMapper {
    public User<YtUserInfo> mapToUser(StaffUser staffUser) {
        val official = staffUser.getOfficial();
        val firstName = staffUser.getName().getFirst();
        val lastName = staffUser.getName().getLast();
        val middleName = staffUser.getName().getMiddle().filter(not(String::isBlank));
        val position = staffUser.getOfficial().getPosition();
        val traits = EntryStream.of(
            Trait.ROBOT, official.isRobot(),
            Trait.HOMEWORKER, official.isHomeworker(),
            Trait.DELETED, staffUser.isDeleted(),
            Trait.DISMISSED, official.isDismissed()
        )
        .filterValues(isEqual(Boolean.TRUE))
        .keys()
        .collect(toEnumSet(Trait.class));

        val info = new YtUserInfo(
            staffUser.getId(),
            official.getAffiliation(),
            staffUser.getWorkEmail(),
            staffUser.getEnvironment().getTimezone(),
            staffUser.getLocation().getOffice().getId(),
            staffUser.getLocation().getTable().getFloor().getNumber(),
            staffUser.getLanguage().getUi(),
            firstName.getRu(),
            lastName.getRu(),
            firstName.getEn(),
            lastName.getEn(),
            middleName,
            position.getRu(),
            position.getEn(),
            staffUser.getPersonal().getGender(),
            staffUser.getWorkPhone(),
            staffUser.getPhones(),
            traits,
            staffUser.getCars(),
            staffUser.userDepartmentId(),
            staffUser.getWorkMode()
        );
        return new User<>(staffUser.safeUid(), UserType.YT, staffUser.getLogin(), info);
    }
}
