package ru.yandex.mail.cerberus.yt.staff;

import com.fasterxml.jackson.databind.JsonNode;
import lombok.AccessLevel;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.Value;
import ru.yandex.mail.cerberus.yt.staff.dto.StaffDto;

import java.util.NoSuchElementException;
import java.util.Optional;

@NoArgsConstructor(access = AccessLevel.PRIVATE)
public abstract class StaffEntity<T> {
    public abstract boolean isValid();
    public abstract T getEntity();
    public abstract Optional<Long> getUniqueId();

    @Value
    @EqualsAndHashCode(callSuper = false)
    public static class Valid<T extends StaffDto> extends StaffEntity<T> {
        T entity;

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public Optional<Long> getUniqueId() {
            return Optional.of(entity.getUniqueId());
        }
    }

    @Value
    @EqualsAndHashCode(callSuper = false)
    public static class Invalid<T> extends StaffEntity<T> {
        JsonNode node;
        Optional<Long> uniqueId;

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public T getEntity() {
            throw new NoSuchElementException("No valid entity");
        }
    }
}
