package ru.yandex.mail.cerberus.yt.staff.client;

import java.util.concurrent.CompletableFuture;

import javax.annotation.Nullable;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Positive;

import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.client.annotation.Client;
import io.micronaut.retry.annotation.Retryable;
import io.micronaut.validation.Validated;

import ru.yandex.mail.cerberus.yt.staff.dto.StaffRoom;
import ru.yandex.mail.micronaut.tvm.auth.TvmSecured;

@Validated
@TvmSecured
@Header(name = "Accept-Encoding", value = "gzip, deflate")
@Retryable(attempts = "${micronaut.http.services.staff.retry-attempts:1}", delay = "100ms")
@Client(id = StaffClient.CLIENT_ID, errorType = String.class)
public interface StaffClient {
    String CLIENT_ID = "staff";

    @Get("/v3/rooms")
    CompletableFuture<StaffResult> rooms(@QueryValue("_nopage") @Min(0) @Max(1) int noPage,
                                         @QueryValue("_sort") @NotBlank String sortBy,
                                         @QueryValue("_limit") @Positive int limit,
                                         @QueryValue("_query") @Nullable String query,
                                         @QueryValue @Nullable StaffRoom.Type type,
                                         @QueryValue("_fields") @Nullable String fields);

    @Get("/v3/persons")
    CompletableFuture<StaffResult> persons(@QueryValue("_nopage") @Min(0) @Max(1) int noPage,
                                           @QueryValue("_sort") @NotBlank String sortBy,
                                           @QueryValue("_limit") @Positive int limit,
                                           @QueryValue("_query") @Nullable String query,
                                           @QueryValue("_fields") @Nullable String fields);

    @Get("/v3/groups")
    CompletableFuture<StaffResult> groups(@QueryValue("_nopage") @Min(0) @Max(1) int noPage,
                                          @QueryValue("_sort") @NotBlank String sortBy,
                                          @QueryValue("_limit") @Positive int limit,
                                          @QueryValue("_query") @Nullable String query,
                                          @QueryValue("_fields") @Nullable String fields);

    @Get("/v3/offices")
    CompletableFuture<StaffResult> offices(@QueryValue("_nopage") @Min(0) @Max(1) int noPage,
                                           @QueryValue("_sort") @NotBlank String sortBy,
                                           @QueryValue("_limit") @Positive int limit,
                                           @QueryValue("_query") @Nullable String query,
                                           @QueryValue("_fields") @Nullable String fields);
}
