package ru.yandex.mail.cerberus.yt.staff.dto;

import java.util.List;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.micronaut.core.annotation.Introspected;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.Value;

import ru.yandex.mail.cerberus.GroupId;

@Value
@Introspected
@AllArgsConstructor(onConstructor_ = @JsonCreator)
public class StaffDepartmentGroup implements StaffDto {
    public static final class Types {
        private Types() {
        }

        public static final String DEPARTMENT = "department";
        public static final String SERVICE = "service";
        public static final String SERVICEROLE = "servicerole";
        public static final String WIKI = "wiki";
    }

    @Value
    @Introspected
    @AllArgsConstructor(onConstructor_ = @JsonCreator)
    public static class Ancestor {
        @Value
        @Introspected
        public static class Info {
            Set<StaffDepartmentHead> heads;
            int level;
        }

        @JsonProperty("is_deleted")
        boolean deleted;
        Info department;
    }

    @JsonDeserialize(builder = StaffDepartment.StaffDepartmentBuilder.class)
    @Builder
    @Data
    @Value
    @Introspected
    public static class StaffDepartment {
        @Value
        @Introspected
        @AllArgsConstructor(onConstructor_ = @JsonCreator)
        public static class Name {

            StaffLocalizedString full;
        }

        @JsonPOJOBuilder(withPrefix = "")
        public static final class StaffDepartmentBuilder {
        }

        Name name;
        String url;
        @JsonProperty("is_deleted")
        boolean deleted;
        Set<StaffDepartmentHead> heads;
    }

    @JsonProperty("_meta")
    Meta meta;
    GroupId id;
    String name;
    String url;
    String type;
    StaffDepartment department;
    List<Ancestor> ancestors;
    @JsonProperty("is_deleted")
    boolean deleted;

    @Override
    @JsonIgnore
    public long getUniqueId() {
        return id.getValue();
    }
}
