package ru.yandex.mail.cerberus.yt.staff.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.micronaut.core.annotation.Introspected;
import lombok.AllArgsConstructor;
import lombok.Value;

import javax.validation.constraints.NotBlank;
import java.util.Optional;

@Value
@Introspected
@AllArgsConstructor(onConstructor_= @JsonCreator)
public class StaffDepartmentHead {
    @Value
    @Introspected
    @AllArgsConstructor(onConstructor_= @JsonCreator)
    public static class Person {
        @NotBlank String uid;
    }

    Person person;

    @JsonIgnore
    public Optional<Long> getUidSafe() {
        try {
            return Optional.of(Long.parseLong(person.uid));
        } catch (NumberFormatException e) {
            return Optional.empty();
        }
    }
}
