package ru.yandex.mail.cerberus.yt.staff.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.micronaut.core.annotation.Introspected;
import lombok.AllArgsConstructor;
import lombok.Value;
import ru.yandex.mail.cerberus.LocationId;

import java.time.ZoneId;

@Value
@Introspected
@AllArgsConstructor(onConstructor_= @JsonCreator)
public class StaffOffice implements StaffDto {
    @Value
    @Introspected
    @AllArgsConstructor(onConstructor_= @JsonCreator)
    public static class City {
        StaffLocalizedString name;
    }

    @JsonProperty("_meta") Meta meta;
    LocationId id;
    StaffLocalizedString name;
    String code;
    City city;
    ZoneId timezone;
    @JsonProperty("is_deleted") boolean deleted;

    @Override
    @JsonIgnore
    public long getUniqueId() {
        return id.getValue();
    }
}
