package ru.yandex.mail.cerberus.yt.staff.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.micronaut.core.annotation.Introspected;
import lombok.AllArgsConstructor;
import lombok.Value;
import ru.yandex.mail.cerberus.LocationId;
import ru.yandex.mail.cerberus.ResourceId;
import ru.yandex.mail.cerberus.yt.data.YtRoomInfo;

import javax.validation.constraints.PositiveOrZero;
import java.util.Optional;
import java.util.OptionalInt;

@Value
@Introspected
@AllArgsConstructor(onConstructor_= @JsonCreator)
public class StaffRoom implements StaffDto {
    @Value
    @Introspected
    public static class Name {
        String display;
        String exchange;
        String alternative;
        String ru;
        String en;
    }

    @Value
    @Introspected
    public static class Floor {
        @Value
        @Introspected
        @AllArgsConstructor(onConstructor_= @JsonCreator)
        public static class Office {
            LocationId id;
        }

        @PositiveOrZero long id;
        Office office;
        OptionalInt number;
    }

    public enum Type {
        OFFICE,
        CONFERENCE,
        SMOKING,
        COFFEE,
        WC,
        WARDROBE,
        WAREHOUSE,
        SERVICE,
        SHOWER,
        GYM,
        LIBRARY;

        @Override
        public String toString() {
            return super.toString().toLowerCase();
        }
    }

    @JsonProperty("_meta") Meta meta;
    ResourceId id;
    @JsonProperty("is_deleted") boolean deleted;
    @JsonProperty("is_bookable") boolean bookable;
    Type type;
    Name name;
    Floor floor;
    String additional;
    Optional<String> capacity;
    YtRoomInfo.Equipment equipment;
    String phone;

    @JsonIgnore
    public int getCapacitySafe() {
        try {
            return capacity.map(Integer::parseUnsignedInt).orElse(0);
        } catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    @JsonIgnore
    public long getUniqueId() {
        return id.getValue();
    }
}
