CREATE DATABASE IF NOT EXISTS auditlog;

CREATE TABLE IF NOT EXISTS auditlog.events ON CLUSTER '{cluster}'
(
    org_id Int64,
    date DateTime64,
    type String,
    uid Int64,
    request_id String,
    json String
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/{database}.{table}', '{replica}')
PARTITION BY toYYYYMM(date)
PRIMARY KEY (org_id, date);

CREATE TABLE IF NOT EXISTS auditlog.disk_events ON CLUSTER '{cluster}'
(
    org_id Int64,
    date DateTime64,
    type String,
    uid Int64,
    request_id String DEFAULT '',
    owner_uid Int64 DEFAULT 0,
    path String DEFAULT ''
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/{database}.{table}', '{replica}')
PARTITION BY toYYYYMM(date)
PRIMARY KEY (org_id, date);
