from mail.devpack.lib.components.clickhouse import ClickHouse


class AuditlogDb(ClickHouse):
    NAME = 'auditlogdb'

    before_all_prefixes = []

    after_all_prefixes = []

    migration_prefixes = [
        'resfs/file/mail/pg/auditlogdb/migrations',
    ]

    snapshot_sql_files = [
        'resfs/file/mail/ch/auditlogdb/auditlog.sql',
    ]

    def __init__(self, env, _):
        users = [
            'auditlogdb',
            'auditlog',
            'tech',
        ]
        self.init_from_conf(env.get_config(), 'auditlogdb', users)
