CREATE DATABASE IF NOT EXISTS auditlog;

CREATE TABLE IF NOT EXISTS auditlog.events ON CLUSTER '{cluster}'
(
    org_id Int64,
    date DateTime64,
    type String,
    uid Int64,
    json String
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/{database}.{table}', '{replica}')
PARTITION BY toYYYYMM(date)
PRIMARY KEY (org_id, date);
