from typing import List, Optional

from mail.ciao.ciao.api.handlers.megamind.base import BaseMegamindHandler
from mail.ciao.ciao.api.schemas.megamind.request import commit_request_json_schema, commit_request_protobuf_schema
from mail.ciao.ciao.api.schemas.megamind.response import commit_response_json_schema, commit_response_protobuf_schema
from mail.ciao.ciao.core.entities.enums import FrameName
from mail.ciao.ciao.core.entities.scenario_response import ScenarioResponse


class CommitMegamindHandler(BaseMegamindHandler):
    PROTOBUF_SCHEMAS = (commit_request_protobuf_schema, commit_response_protobuf_schema)
    JSON_SCHEMAS = (commit_request_json_schema, commit_response_json_schema)
    COMMIT = True
    REQUEST_TYPE = 'commit'

    @staticmethod
    def get_frames_data(data: dict) -> List[dict]:
        # https://wiki.yandex-team.ru/mail/swat/ciao/Alice-gotchas/#m-kakrabotaetkommit
        return data.get('arguments', {}).get('semantic_frames', [])

    @classmethod
    def make_response_data(cls,
                           scenario_response: ScenarioResponse,
                           frame_name: Optional[FrameName] = None,
                           data: Optional[dict] = None,
                           ) -> dict:
        if scenario_response.error:
            return super().make_response_data(scenario_response, frame_name, data)
        else:
            return {'success': {}}
