from typing import List

from mail.ciao.ciao.api.handlers.megamind.base import BaseMegamindHandler
from mail.ciao.ciao.api.schemas.megamind.request import run_request_json_schema, run_request_protobuf_schema
from mail.ciao.ciao.api.schemas.megamind.response import run_response_json_schema, run_response_protobuf_schema


class RunMegamindHandler(BaseMegamindHandler):
    PROTOBUF_SCHEMAS = (run_request_protobuf_schema, run_response_protobuf_schema)
    JSON_SCHEMAS = (run_request_json_schema, run_response_json_schema)
    COMMIT = False
    REQUEST_TYPE = 'run'

    @staticmethod
    def get_frames_data(data: dict) -> List[dict]:
        return data.get('input', {}).get('semantic_frames', [])
