import logging
import uuid

from sendr_qlog import LoggerContext
from sendr_taskqueue.background import BackgroundTask

from mail.ciao.ciao.conf import settings
from mail.ciao.ciao.interactions.calendar import PublicCalendarClient


class PingerTask(BackgroundTask):
    pause_period = settings.PINGER_PERIOD

    def __init__(self, *args, **kwargs):
        super().__init__(
            *args,
            logger=LoggerContext(logging.getLogger('pinger'), {}),
            **kwargs,
        )

    async def _run(self):
        try:
            client = PublicCalendarClient(
                logger=self.logger,
                request_id=f'pinger_{uuid.uuid4().hex}',
            )
            await client.ping()
        finally:
            await client.close()
