from marshmallow import fields, post_load

from mail.ciao.ciao.api.schemas.base import BaseSchema
from mail.ciao.ciao.interactions.calendar.entities import Event


class EventSchema(BaseSchema):
    event_id = fields.Integer(required=True)
    external_id = fields.String(required=True)
    name = fields.String(required=True)
    description = fields.String(required=True)
    start_ts = fields.DateTime(required=True)
    end_ts = fields.DateTime(required=True)
    others_can_view = fields.Boolean(required=True)
    sequence = fields.Integer(required=True)
    all_day = fields.Boolean(required=True)

    @post_load
    def build_entity(self, data):
        return Event(**data)
