from dateutil.relativedelta import relativedelta
from marshmallow import fields, post_load

from sendr_utils import without_none

from mail.ciao.ciao.api.schemas.base import BaseSchema


class RelativedeltaSchema(BaseSchema):
    years = fields.Integer(allow_none=True)
    months = fields.Integer(allow_none=True)
    days = fields.Integer(allow_none=True)
    leapdays = fields.Integer(allow_none=True)
    hours = fields.Integer(allow_none=True)
    minutes = fields.Integer(allow_none=True)
    seconds = fields.Integer(allow_none=True)
    microseconds = fields.Integer(allow_none=True)
    year = fields.Integer(allow_none=True)
    month = fields.Integer(allow_none=True)
    day = fields.Integer(allow_none=True)
    hour = fields.Integer(allow_none=True)
    minute = fields.Integer(allow_none=True)
    second = fields.Integer(allow_none=True)
    microsecond = fields.Integer(allow_none=True)
    weekday = fields.Integer(allow_none=True)

    @post_load
    def build_relativedelta(self, data):
        return relativedelta(**without_none(data))
