from marshmallow import fields, post_load

from sendr_utils import without_none

from mail.ciao.ciao.api.schemas.base import BaseSchema
from mail.ciao.ciao.utils.datetime import UserDate


class UserDateSchema(BaseSchema):
    day = fields.Integer(allow_none=True)
    month = fields.Integer(allow_none=True)
    year = fields.Integer(allow_none=True)
    weeks = fields.Integer(allow_none=True)
    weekday = fields.Integer(allow_none=True)
    relative = fields.Boolean()

    @post_load
    def build_user_date(self, data):
        return UserDate(**without_none(data))
