from marshmallow import fields, post_load
from marshmallow_enum import EnumField

from sendr_utils import without_none

from mail.ciao.ciao.api.schemas.base import BaseSchema
from mail.ciao.ciao.utils.datetime import Period, UserTime


class UserTimeSchema(BaseSchema):
    hour = fields.Integer(allow_none=True)
    minute = fields.Integer(allow_none=True)
    second = fields.Integer(allow_none=True)
    period = EnumField(Period, by_value=True, allow_none=True)
    relative = fields.Boolean()

    @post_load
    def build_user_time(self, data):
        return UserTime(**without_none(data))
