from marshmallow import fields


class DateTimeTz(fields.DateTime):
    def _deserialize(self, *args, **kwargs):
        value = super()._deserialize(*args, **kwargs)
        if value.tzinfo is None:
            self.fail('invalid')
        return value


class DictStrToNested(fields.Nested):
    def __init__(self, nested, *args, **kwargs):
        super().__init__(nested, many=True, *args, **kwargs)

    def _serialize(self, nested_obj, attr, obj):
        """
        Serializes `{"key1": value1, "key2": value2}` into:
            `{"key1": serialized1, "key2": serialized2}`.
        """
        if not isinstance(nested_obj, dict) or not all((isinstance(key, str) for key in nested_obj)):
            self.fail('type')
        nested_list = super()._serialize(nested_obj.values(), attr, obj)
        d = {
            key: value
            for key, value in zip(nested_obj, nested_list)
        }
        return d

    def _deserialize(self, value, attr, data):
        raise NotImplementedError
