from marshmallow import fields, pre_dump
from marshmallow_enum import EnumField

from mail.ciao.ciao.api.schemas.megamind.base import BaseMegamindSchema
from mail.ciao.ciao.core.entities.analytcs import Action, Intent


class ActionSchema(BaseMegamindSchema):
    id = EnumField(Action, by_value=True)


class ObjectSchema(BaseMegamindSchema):
    id = fields.String()
    name = fields.String()
    human_readable = fields.String()


class AnalyticsInfoSchema(BaseMegamindSchema):
    intent = EnumField(Intent, by_value=True)
    actions = fields.Nested(ActionSchema, many=True)
    objects = fields.Nested(ObjectSchema, many=True)

    @pre_dump
    def pre_dump_actions(self, analytics):
        analytics.actions = [{'id': action} for action in analytics.actions]
        return analytics
