from marshmallow import fields, pre_dump

from mail.ciao.ciao.api.schemas.megamind.base import BaseMegamindSchema
from mail.ciao.ciao.core.entities.button import TypeTextButton, UriButton


class OpenUriDirectiveSchema(BaseMegamindSchema):
    uri = fields.String()


class TypeTextDirectiveSchema(BaseMegamindSchema):
    text = fields.String()


class DirectiveSchema(BaseMegamindSchema):
    open_uri_directive = fields.Nested(OpenUriDirectiveSchema)
    type_text_directive = fields.Nested(TypeTextDirectiveSchema)

    @pre_dump
    def route_button(self, data):
        if isinstance(data, UriButton):
            return {'open_uri_directive': data}
        elif isinstance(data, TypeTextButton):
            return {'type_text_directive': data}
        else:
            raise NotImplementedError


class DirectiveListSchema(BaseMegamindSchema):
    list = fields.Nested(DirectiveSchema, many=True)
