from marshmallow import fields, post_dump, post_load

from mail.ciao.ciao.api.schemas.megamind.base import BaseMegamindSchema
from mail.ciao.ciao.api.schemas.megamind.slot import SlotSchema


class SemanticFrameSchema(BaseMegamindSchema):
    name = fields.String()
    slots = fields.List(fields.Dict, many=True)

    @post_load
    def load_slots(self, data):
        raw_slots = data.pop('slots', [])
        slots = [SlotSchema(strict=False).load(slot) for slot in raw_slots]
        loaded_slots = []
        for slot in slots:
            if slot.errors:
                with self.logger:
                    self.logger.context_push(slot_errors=slot.errors)
                    self.logger.info('Failed to load slot.')
            else:
                loaded_slots.append(slot.data)
        data['slots'] = loaded_slots
        return data

    @post_dump
    def dump_slots(self, data):
        raw_slots = data.pop('slots', [])
        data['slots'] = SlotSchema().dump(raw_slots, many=True).data
        return data
