from datetime import date

from marshmallow import fields, post_load

from sendr_utils import without_none

from mail.ciao.ciao.api.schemas.base import BaseSchema
from mail.ciao.ciao.utils.datetime import UserDate


class SysDateSchema(BaseSchema):
    """
    Example value: '{"days":1,"days_relative":true}'.
    """

    days = fields.Integer()
    months = fields.Integer()
    years = fields.Integer()
    weeks = fields.Integer()
    weekday = fields.Integer()
    days_relative = fields.Boolean()
    months_relative = fields.Boolean()
    years_relative = fields.Boolean()
    weeks_relative = fields.Boolean()

    @post_load
    def build_user_date(self, data):
        relative = any((key.endswith('_relative') for key in data))
        return UserDate(**without_none(dict(
            day=data.get('days'),
            month=data.get('months'),
            year=data.get('years'),
            weeks=data.get('weeks'),
            weekday=data.get('weekday'),
            relative=relative,
        )))


_sys_date_schema = SysDateSchema()


def parse_sys_date(value: str) -> date:
    return _sys_date_schema.loads(value).data
