from marshmallow import fields, post_load
from marshmallow_enum import EnumField

from sendr_utils import without_none

from mail.ciao.ciao.api.schemas.base import BaseSchema
from mail.ciao.ciao.utils.datetime import Period, UserTime


class SysTimeSchema(BaseSchema):
    """
    Example value: '{"hours":9,"period":"am"}'
    """
    hours = fields.Integer()
    minutes = fields.Integer()
    seconds = fields.Integer()
    hours_relative = fields.Boolean()
    minutes_relative = fields.Boolean()
    seconds_relative = fields.Boolean()
    period = EnumField(Period, by_value=True)

    @post_load
    def build_user_time(self, data):
        relative = any((key.endswith('_relative') for key in data))
        return UserTime(**without_none(dict(
            hour=data.get('hours'),
            minute=data.get('minutes'),
            second=data.get('seconds'),
            period=data.get('period'),
            relative=relative,
        )))


_sys_time_schema = SysTimeSchema()


def parse_sys_time(value: str) -> UserTime:
    return _sys_time_schema.loads(value).data
